{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.09.98 - 10:49:57 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMObj, MMUtils, MMDIBCv, MMLevel, MMConect, MMDesign,
  MMWave, MMWaveIO, MMDSPObj, MMWavOut, MMACMCvt, MMHook;

type
  TForm1 = class(TForm)
    WaveOut: TMMWaveOut;
    WaveFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    Connector: TMMConnector;
    MMLevel1: TMMLevel;
    Button1: TButton;
    OpenDialog: TOpenDialog;
    Button2: TButton;
    DSPInterface: TMMDSPInterface;
    btnCreate: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveOutStop(Sender: TObject);
    procedure DSPInterfaceBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure btnCreateClick(Sender: TObject);
    procedure DSPInterfaceBufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr; var MoreBuffers: Boolean);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses uLaw;

// if you need any byte conversion remove the point and
// include your conversion in OnBufferFilled
{.$DEFINE ULAW_CONVERT}

{------------------------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
var
   lpwio: PWaveIOCB;

begin
   if OpenDialog.Execute then
   begin
      // We assume you load a 16 Bit, Stereo, 44 Khz file
      wioBuildFileInfoFromRAW(lpwio,
                              PChar(OpenDialog.FileName),
                              0,      // Offset of the Data , in the rule 0
                              16,     // (dest) BitLength
                              1,      // number of channels
                              44100); // SampleRate
      if (lpwio <> nil) then
      begin
         { create a wave }
         WaveFile.Wave.PWaveIOInfo := lpwio;

         { start playing }
         WaveOut.Start;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   { free the file }
   WaveFile.Wave.FreeWave;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
{$IFDEF ULAW_CONVERT}
var
   i: integer;
{$ENDIF}
begin
   {$IFDEF ULAW_CONVERT}
   // here you can include any conversion, i.e. mu-law
   with lpWaveHdr^ do
   begin
      for i := dwBytesRecorded-1 downto 0 do
      begin
         PSmallArray(lpData)[i] := uLaw2Linear(PByteArray(lpData)[i]);
      end;
      { now we have the buffersize increased }
      dwBytesRecorded := 2*dwBytesRecorded;
   end;
   {$ENDIF}
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterfaceBufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr; var MoreBuffers: Boolean);
begin
   {$IFDEF ULAW_CONVERT}
   // we use a nice trick here before the data gets loaded,
   // because we convert from 8 to 16 Bit we must only load the half BufferSize
   lpWaveHdr^.dwBufferlength := lpWaveHdr^.dwBufferlength div 2;
   {$ENDIF}
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnCreateClick(Sender: TObject);
var
   nRead: Longint;
   Buf: array[0..4096-1] of Char;
   h: THandle;
   i: integer;

begin
   if OpenDialog.Execute then
   begin
      WaveFile.Wave.FileName := OpenDialog.Filename;
      WaveFile.Wave.OpenFile;
      try
         h := FileCreate('E:\TEST.RAW');
         repeat
             nRead := WaveFile.Wave.ReadDataBytes(@Buf, sizeOf(Buf));
             if (nRead > 0) then
             begin
                for i := 0 to (nRead div 2)-1 do
                begin
                   Buf[i] := Char(Linear2uLaw(PSmallArray(@Buf)^[i], False));
                end;
                FileWrite(h, Buf, nRead div 2);
             end;

         until nRead <= 0;

         FileClose(h);

      finally
         Wavefile.Wave.CloseFile;
      end;
   end;
end;

end.
